undum.game.id = 'A7798F78-C870-11E2-90CC-606C662AE7E3'; // IFID
undum.game.version = '2.0';

undum.game.qualityGroups = {};
undum.game.qualities = {};

$.fn.quiet_focus = function() {
    var reference = $(document);
    var x = reference.scrollLeft();
    var y = reference.scrollTop();
    this.focus();
    window.scrollTo(x, y);
};

function first_time(character, memento) {
    var result = (typeof character.sandbox[memento] == 'undefined');
    character.sandbox[memento] = 'seen';
    return result;
}

function dinkus(system) {
    system.write('<p class="dinkus">▴&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;▲&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;▴</p>');
}

function clear_chapter(system, character, number) {
    $('#chapter-number').text(number);
    system.setChapterText('');
}

function substitute(text, character) {
    for (var i = character.sandbox.flags.length; i--;) {
	var flag = character.sandbox.flags[i];
	do {
	    var prior = text;
	    text = text
		.replace(new RegExp('\\[' + flag + '\\](.*?)\\[end ' + flag + '\\]', 'g'), '$1')
		.replace(new RegExp('\\[~' + flag + '\\].*?\\[end ~' + flag + '\\]', 'g'), '');
	} while (prior != text);
    }
    do {
	var prior = text;
	text = text
	    .replace(new RegExp('\\[~(.*?)\\](.*?)\\[end ~\\1\\]', 'g'), '$2')
	    .replace(new RegExp('\\[([^~]*?)\\].*?\\[end \\1\\]', 'g'), '');
    } while (prior != text);
    return text;
}

function rechapter(system, character, number, title, setting, protagonist) {
    title = substitute(title, character);
    setting = substitute(setting, character);
    protagonist = substitute(protagonist, character);
    system.setChapterText('<h2 class="chapter-title">' + title + '</h2><h2><strong>' + setting + '</strong></h2><h2>Protagonist: <strong>' + protagonist + '</strong></h2>');
}

function chapter(system, character, number, title, setting, protagonist) {
    title = substitute(title, character);
    setting = substitute(setting, character);
    protagonist = substitute(protagonist, character);
    system.write('<h1>Chapter ' + number + ': “' + title + '”</h1>');
    system.setChapterText('<h2 class="chapter-title">' + title + '</h2><h2><strong>' + setting + '</strong></h2><h2>Protagonist: <strong>' + protagonist + '</strong></h2>');
}

function paragraph(system, character, text) {
    text = substitute(text, character);
    system.write('<p>' + text + '</p>');
}

function list_separator(index, bound) {
    if (index <= 0) {
	return '';
    }
    if (bound == 2) {
	return ' and ';
    }
    if (index + 1 == bound) {
	return ', and ';
    }
    return ', ';
}

function clear_flags(character, flags) {
    character.sandbox.flags = character.sandbox.flags.filter(function(flag) {
	return flags.indexOf(flag) < 0;
    });
}

function verbs(system, character, verbs, templates, newly) {
    var text = (newly ? 'Newly available' : 'Recently introduced') + ' verb' + (verbs.length == 1 ? '' : 's') + ': ';
    for (var i = 0; i < verbs.length; ++i) {
	text += list_separator(i, verbs.length) + '<strong>' + verbs[i] + '</strong>';
    }
    system.write('<p id="note" class="transient">' + text + '.</p>');
    if (newly) {
	character.sandbox.templates = character.sandbox.templates.concat(synonyms(templates, {}));
    }
}

function few_verbs(system, character, verbs) {
    var text = 'You are low on options.  Consider ' + (verbs.length == 1 ? 'this verb' : 'these verbs') + ': ';
    for (var i = 0; i < verbs.length; ++i) {
	text += list_separator(i, verbs.length) + '<strong>' + verbs[i] + '</strong>';
    }
    system.write('<p id="note2" class="transient">' + text + '.</p>');
}

function goals(system, character, goals) {
    var text = 'Immediate goal' + (goals.length == 1 ? '' : 's') + ': ';
    for (var i = 0; i < goals.length; ++i) {
	text += '<li>' + substitute(goals[i], character) + '</li>';
    }
    system.write('<div id="goals" class="transient"><ul>' + text + '</ul></div>');
}

function pause(system, href) {
    system.write('<p class="transient"><a class="sticky click_message" href="' + href + '">click to continue</a></p>');
    $('a.click_message').quiet_focus();
}

function flatten(array) {
    return array.reduce(function(flattening, element) {
	return flattening.concat(element);
    }, []);
}

var parse_counter = 0;
function parse(that, system, character, choices, prompt) {
    choices = flatten(choices.concat(character.sandbox.templates));
    var few_verb_lists = get_few_verbs_lists(choices);
    if (few_verb_lists.useful.length > 0 && few_verb_lists.useful.length < 4 && 2 * few_verb_lists.useful.length <= few_verb_lists.possible.length) {
	few_verbs(system, character, few_verb_lists.useful);
    }
    for (var i = choices.length; i--;) {
	if (typeof choices[i].thought != 'undefined') {
	    choices[i].thought = substitute(choices[i].thought, character);
	}
    }
    var id = 'hybrid-' + parse_counter;
    ++parse_counter;
    system.write('<div class="parser-choice-hybrid" id="' + id + '"></div>');
    $('#' + id).parser_choice_hybrid({
	prompt: prompt,
	choices: choices,
	handler: function(choice) {
	    that.exit = function() {
		if (typeof choice.transition !== 'undefined') {
		    paragraph(system, character, choice.transition);
		}
		if (typeof choice.flags !== 'undefined') {
		    character.sandbox.flags = character.sandbox.flags.concat(choice.flags);
		}
	    }
	    system.doLink(choice);
	}
    });
    $('#' + id + ' input').quiet_focus();
}

function synonyms(commands, rest) {
    return commands.map(function(command) {
	return $.extend({command: command}, rest);
    });
}

function flag_blocked_synonyms(character, flags, commands, rest) {
    for (var i = flags.length; i--;) {
	var flag = flags[i];
	if (character.sandbox.flags.indexOf(flag) >= 0) {
	    return [];
	}
    }
    return commands.map(function(command) {
	return $.extend({command: command}, rest);
    });
}

function flag_locked_synonyms(character, enabling_flags, disabling_flags, commands, rest) {
    for (var i = enabling_flags.length; i--;) {
	var flag = enabling_flags[i];
	if (character.sandbox.flags.indexOf(flag) >= 0) {
	    return flag_blocked_synonyms(character, disabling_flags, commands, rest);
	}
    }
    return [];
}

// Copied from undum.js
/* Fades in and out a highlight on the given element. */
function showHighlight(domElement) {
    var highlight = domElement.find(".highlight");
    if (highlight.size() <= 0) {
        highlight = $('<div>').addClass('highlight');
        domElement.append(highlight);
    }
    highlight.fadeIn(250);
    setTimeout(function() {
        highlight.fadeOut(1000);
    }, 2000);
};

function end(system) {
    var authors_notes = $("#authors_notes");
    authors_notes.css('display', 'block');
    showHighlight(authors_notes);
    system.write('<p id="authors_notes_note">(<a class="sibling" href="authors-notes.html" target="_blank">Author\'s Notes</a>)</p>');
}

undum.game.init = function(character, system) {
    character.sandbox.flags = [];
    character.sandbox.templates = [];
    // Not necessary at startup, but important in case of an "erase".
    clear_chapter(system, character, '1');
}

undum.game.start = 'start';
undum.game.situations = {
    start: new undum.Situation({
	enter: function(character, system, from) {
	    system.write('<p class="transient">If this is your first time reading <em>An Earth Turning Slowly</em>, you may wish to <a class="sibling" href="instructions.html" target="_blank">view the instructions</a> first.  There is also a link in the information panel, which is usually displayed to the left of the story, in case you ever need to refresh your memory.</p>');
	    // pause(system, 'prologue');
	    pause(system, 'chapter1');
	}
    }),
    // prologue: new undum.Situation({
    // 	enter: function(character, system, from) {
    // 	    system.write('<p class="transient">There are two endings.  I will let you decide between them.</p>');
    // 	    pause(system, 'chapter1');
    // 	}
    // }),
    chapter1: new undum.Situation({
	enter: function(character, system, from) {
	    paragraph(system, character, '“You\'re going to clip a plate, Joanna.  Can you bring the grip on this side further back?”');
	    paragraph(system, character, '“Man, this\'ll be close.  Morgan, you sure I can\'t come forward a bit?”');
	    paragraph(system, character, '“You stay away from that rib cage.  That\'s my data.”');
	    paragraph(system, character, '“Well, okay.  Give your engine a rev and see if she won\'t swing her tail a little more in your direction.  Arthur, keep an eye on that plate.”');
	    $('#content hr').first().remove();
	    pause(system, 'poorgirl');
	}
    }),
    poorgirl: new undum.Situation({
	enter: function(character, system, from) {
	    if (first_time(character, 'poorgirl')) {
		chapter(system, character, '1', 'Injury', 'Puzzlegrass Forest – Morning', 'Morgan');
		paragraph(system, character, '“Poor girl,” whispered Arthur.  Four vertical gashes marred the stegosaurid\'s left side, and the broken end of one rib was still visible.  She was struggling, but the Armatron could restrain even healthy adults.  “I want to take vitals.”');
		paragraph(system, character, '“Okay.  I\'m going to see if these bites have what I\'m looking for.  Carter, Giles, you get the contralateral measurements.”');
		goals(system, character, ['investigate the stegosaurid\'s injuries', 'start a conversation with Arthur (whom Morgan likes)']);
		verbs(system, character, ['look at', 'take', 'talk to'], ['x … (look at …)', 'look at …', 'take …', 'talk to …'], true);
	    } else {
		goals(system, character, ['investigate the stegosaurid\'s injuries', 'start a conversation with Arthur (whom Morgan likes)']);
		verbs(system, character, ['look at', 'take', 'talk to'], ['x … (look at …)', 'look at …', 'take …', 'talk to …'], false);
	    }
	    parse(this, system, character, [
		flag_blocked_synonyms(character, ['equipment', 'extra'], ['x her equipment (look at her equipment)', 'look at her equipment'], {
		    thought: 'Regulations don\'t allow teams to detain an animal for very long.  It\'s better to be sure of my equipment than to waste time getting useless data.',
		    flags: ['equipment', 'she'],
		    transition: '[she]She[end she][~she]Morgan[end ~she] unslung her pack, shook the rain off, and laid her equipment out neatly, satisfying herself that all was in working order.',
		    link: '.'}),
		flag_blocked_synonyms(character, ['cliff', 'extra'], ['x her data pad (look at her data pad)', 'look at her data pad'], {
		    thought: 'The data pad collects telemetrics from tagged animals; the last few days\' worth might hold some clues to these injuries.',
		    flags: ['cliff'],
		    transition: 'Glancing at her data pad, she saw that the stegosaurid\'s tracker had already uploaded its telemetrics.  The animal had been pinned against a cliffside the day before, though there was little information on the attackers; apparently they weren\'t tagged.',
		    link: '.'}),
		flag_blocked_synonyms(character, ['equipment', 'cliff', 'extra', 'shared', 'grip'], ['x Arthur (look at Arthur)', 'look at Arthur'], {
		    thought: 'Exopaleopathology is serious work, but that doesn\'t mean there\'s no time to enjoy the scenery.',
		    flags: ['romance'],
		    transition: 'Despite the business-like tone, she unbundled her equipment rather absentmindedly, her eyes stuck on a particular someone taking the animal\'s pulse.  There was some data coming that would usurp that distraction, but it took a good minute for the realization to hit her.',
		    link: 'fractures'}),
		flag_blocked_synonyms(character, ['shared', 'extra'], ['x Joanna (look at Joanna)', 'look at Joanna'], {
		    thought: 'Joanna will be proud.',
		    flags: ['shared', 'she'],
		    transition: '[she]She[end she][~she]Morgan[end ~she] glanced back at Joanna, who was sitting in the Armatron driver\'s seat.  Joanna had put a lot of faith in her, bringing on an exopaleopathologist with so many contenders from more mainstream fields beating down the door.  The results had been enough to justify the decision, but never as spectacular as Morgan had wanted.  But now, here, she scented something big.',
		    link: '.'}),
		flag_blocked_synonyms(character, ['shared', 'extra'], ['x Carter and Giles (look at Carter and Giles)', 'look at Carter and Giles'], {
		    thought: 'This could be it.  Do those two realize that?',
		    flags: ['shared', 'she'],
		    transition: '[she]She[end she][~she]Morgan[end ~she] kept her eye on the students as best she could.  They were really top-notch—had to be to be working here—but they didn\'t seem to realize just how special this specimen was.  She, however, knew that it would launch their careers.',
		    link: '.'}),
		flag_blocked_synonyms(character, ['grip', 'shared', 'extra'], ['x the Armatron grip (look at the Armatron grip)', 'look at the Armatron grip'], {
		    thought: 'Joanna was right about it being close.  Now\'s not the time for any mishaps.  I could put myself in its way if it looks like it might slip forward.',
		    flags: ['grip', 'she'],
		    transition: '[she]She[end she][~she]Morgan[end ~she] planted her shoulder against the near side of the Armatron grip and tried not to make eye contact with Joanna.  It was a silly move, really.  Not like she could do actually anything if the dino got squirmy—she was just making Joanna\'s job harder.  Still, [she]Morgan[end she][~she]she[end ~she] felt better with something between the Armatron and the wound site.  This data was going to be good.',
		    link: '.'}),
		flag_blocked_synonyms(character, ['extra'], ['x the plates (look at the plates)', 'look at the plates'], {
		    thought: 'Context is key.  The bites are obvious, but there may be damage elsewhere that would better hint at what happened.',
		    flags: ['extra', 'she'],
		    transition: 'One thing struck [she]her[end she][~she]Morgan[end ~she] immediately: the dino\'s plates weren\'t flushing.  She puzzled over their pallor for some time, but eventually had to turn to the wounds.  They couldn\'t keep the animal restrained forever.',
		    link: '.'}),
		flag_blocked_synonyms(character, ['extra'], ['x the tail (look at the tail)', 'look at the tail'], {
		    thought: 'Context is key.  The bites are obvious, but there may be damage elsewhere that would better hint at what happened.',
		    flags: ['extra', 'she', 'equipment'],
		    transition: '[she]She[end she][~she]Morgan[end ~she] eyed the tail spikes while she got her equipment ready—not an easy task with it swinging so wildly.  The right anterior spike was dorsoventrally flattened, but nothing else jumped out at her.  She\'d need the wound data to come through.',
		    link: '.'}),
		synonyms(['x the rib cage (look at the rib cage)', 'look at the rib cage', 'take measurements'], {
		    thought: 'This specimen survived multiple flesh-grazer bites, possibly all from the same encounter and in roughly the same location.  A rare find and worth a closer look.',
		    transition: 'Morgan [~equipment]unslung her pack, rummaged for the appropriate equipment, and [end ~equipment]started taking measurements.',
		    link: 'fractures'}),
		synonyms(['x the bites (look at the bites)', 'look at the bites'], {
		    thought: 'It would be interesting to know what predator—or predators—did this.  The bite patterns here are unlike most flesh grazers\' I\'ve seen, and it might take some thinking to fully reconstruct the encounter.',
		    transition: 'Based on the sickle-claw marks and the strength and jaw sizes necessary to inflict those wounds, Morgan inferred that the predators were several, and probably all adult megatroödontidae.  Megatroödontidae, in her experience, were good at separating individuals from the herd, so the bites all falling on the stegosaurid\'s left flank probably meant that she had covered her right side with terrain.  That would also explain her wounds being forward, in the less meaty areas, as her tail would have had less of an angle to cover and therefore held more threat for her attackers.  Even managing what they did must have been perilous; the bites were haphazard, and would have done more bone than muscular damage.  Which was good news for Morgan, as a record of the skeletal injuries would fit right in with her research.  She began taking measurements.',
		    link: 'fractures'}),
		flag_blocked_synonyms(character, ['stellar'], ['talk to Arthur'], {
		    thought: 'Quite the guy, isn\'t he?  Here\'s a chance to strike up a conversation.',
		    flags: ['stellar', 'romance', 'flirtation'],
		    transition: '“How\'s she look, Arthur?” Morgan inquired, intent on getting a conversation going.</p><p>“Erm, give me a bit.”</p><p>Not really a stellar start.',
		    link: '.'}),
		flag_locked_synonyms(character, ['stellar'], ['nailed'], ['talk to Arthur'], {
		    thought: 'I guess I should try again.',
		    flags: ['nailed', 'romance', 'flirtation'],
		    transition: '“Bet you got her situation nailed down already, don\'t you?” she teased.</p><p>“Well, I\'ve hardly gotten past taking her pulse.”</p><p>Another misfire.  Dogged, she turned back to the stegosaurid looking for something to say about it.',
		    link: '.'}),
	    ], 'Have Morgan …');
	}
    }),
    fractures: new undum.Situation({
	enter: function(character, system, from) {
	    if (first_time(character, 'fractures')) {
		clear_flags(character, ['equipment', 'extra', 'cliff', 'shared', 'stellar', 'nailed', 'she']);
		paragraph(system, character, 'What she found was everything she could hope for.  Several comminuted fractures.  Haematomas with higher-than-expected levels of TGF-β.  Clear signs of variable response in the exuberant callus formation.  And higher up, evidence of early-stage pseudarthrosis.  Gold.');
	    }
	    goals(system, character, ['start a conversation with Arthur']);
	    verbs(system, character, ['look at', 'take', 'talk to'], ['x … (look at …)', 'look at …', 'take …', 'talk to …'], false);
	    parse(this, system, character, [
		flag_locked_synonyms(character, ['grip'], ['budged', 'Joanna', 'students'], ['x the Armatron grip (look at the Armatron grip)', 'look at the Armatron grip'], {
		    thought: 'The only risk with this find is that the unorthodox capture will invite doubts of secondary damage.',
		    flags: ['budged'],
		    transition: 'She checked the Armatron grip again and recorded its position in case of later questions.  It had hardly budged.  Joanna knew what she was doing.',
		    link: '.'}),
		flag_blocked_synonyms(character, ['Joanna'], ['x Joanna (look at Joanna)', 'look at Joanna'], {
		    thought: 'I want to share this with Arthur first, but I need to be careful that Joanna doesn\'t think I\'m letting personal interests interfere with my work.  Is she sufficiently distracted?',
		    flags: ['Joanna', 'romance'],
		    transition: 'She glanced over her shoulder.  Joanna might guess her motive in talking to Arthur before her students.  But one look settled that question: Joanna was so intent on maintaining the Armatron\'s odd grip that she could hardly notice something like that.',
		    link: '.'}),
		flag_blocked_synonyms(character, ['students'], ['x Carter and Giles (look at Carter and Giles)', 'look at Carter and Giles'], {
		    thought: 'I want to share this just with Arthur for a bit, but I need to be mindful of mixing professional and personal interests in front of my students.  Will they notice?',
		    flags: ['students', 'romance'],
		    transition: 'She poked her head over the stegosaurid\'s plates.  Carter and Giles would probably have some idea of what she was up to.  On the other hand, they had a lot of pressure to get their data right, and it was her own business what she did while waiting for them.',
		    link: '.'}),
		synonyms(['talk to Arthur'], {
		    thought: 'I need to share this with someone, and I want that someone to be Arthur.  I could get him involved by asking for help with something he\'s good at.',
		    flags: ['romance', 'flirtation'],
		    transition: '“Hey, Arthur, can you help me with these osteoblast counts?”  She smiled.  He left off to join her.',
		    link: 'osteoblasts'}),
		synonyms(['x her data pad (look at her data pad)', 'look at her data pad'], {
		    thought: 'A second set of eyes on this data wouldn\'t hurt.  I could find some bits that Arthur would be expert on.',
		    transition: '“Hey, Arthur, can you see if these osteoblast counts are in line with your observations?”  She smiled.  He left off to join her.',
		    link: 'osteoblasts'}),
	    ], 'Have Morgan …');
	}
    }),
    osteoblasts: new undum.Situation({
	enter: function(character, system, from) {
	    clear_flags(character, ['grip', 'budged', 'Joanna', 'students']);
	    paragraph(system, character, '“Thanks.”  And, in an undertone, “Really, I just wanted you to see this first!”  She ran through her list of findings. “We\'ve never had one quite like her.  The diversity of simultaneous wounds, I mean, in a surviving specimen.  There\'s this long-standing hand-wave in paleopathology: we assume that multi-wound healing in dinosaurs was mediated the same way it is in birds, never mind the millions of years of intervening evolution.  Now we can start to fill that gap in.”');
	    paragraph(system, character, '“Morgan, I think she\'s in shock.  Her capillary refill time\'s at six seconds.”');
	    paragraph(system, character, '“Oh.  And these bites aren\'t that old.  Impaired haematopoiesis?”');
	    paragraph(system, character, '“Maybe.  The point is, if we don\'t do something, she\'s not going to make it.”');
	    pause(system, 'past');
	}
    }),
    past: new undum.Situation({
	enter: function(character, system, from) {
	    if (first_time(character, 'past')) {
		paragraph(system, character, 'Arthur had been brought on in a hurry just a month ago, after a collision in a tidal race left one rhomaleosaurid bleeding badly and two predation studies ruined.  He\'d gotten the animal fixed up, which was enough of a miracle that Joanna had secured a full-length stay for him.  Morgan had thought him cute, especially with his funny walk from not being used to the higher gravity, and, with some persistence, convinced Joanna that he should join them on rover outings.  He\'d been on two tagging expeditions so far, but this was his first time seeing the creatures up close.');
		paragraph(system, character, 'The experience, it would seem, wasn\'t sitting very well with him.');
		goals(system, character, ['enjoy her conversation with Arthur', 'persuade Arthur not to interfere with the wildlife']);
		verbs(system, character, ['wait', 'point out'], ['point out …'], true);
	    } else {
		goals(system, character, ['enjoy her conversation with Arthur', 'persuade Arthur not to interfere with the wildlife']);
		verbs(system, character, ['wait', 'point out'], ['point out …'], false);
	    }
	    parse(this, system, character, [
		synonyms(['x Arthur (look at Arthur)', 'look at Arthur', 'wait', 'z (wait)'], {
		    thought: 'Hold on.  What is Arthur getting at?',
		    flags: ['gotten'],
		    transition: 'He stood there sweating, waiting for her to do something.  She stood waiting for him to explain what he was getting at.</p><p>“You want to save her?  You know that\'s not an option.”',
		    link: 'crystalloid'}),
		synonyms(['x the stegosaurid (look at the stegosaurid)', 'look at the stegosaurid'], {
		    thought: 'Maybe I can reassure Arthur with my data.',
		    flags: ['sidled'],
		    transition: '“I don\'t know,” said Morgan, glancing at the rib cage again.  “She seems to be doing pretty well—she\'s keeping up with the herd.  And look at all these healing responses.”  She sidled up to him so he could peer over her shoulder.  “I don\'t think we\'d see her body spend energy like this if shock was about to kill her.”</p><p>',
		    link: 'crystalloid'}),
		synonyms(['talk to Arthur'], {
		    thought: 'I can sympathize, but at the same time I can\'t let him violate our ethical guidelines.',
		    transition: 'What a swing of emotions.  “Arthur, I know this can\'t be easy, but if she\'s going to die, we have to let that happen.”  She put her hand on his arm.  “Our job is to minimize human interference.  While that usually means helping animals we\'ve hurt, sometimes it\'s also not helping the animals we haven\'t.”',
		    link: 'crystalloid'}),
		synonyms(['talk to Joanna'], {
		    thought: 'Joanna let\'s me take charge when it comes to science, but I don\'t want to argue with Arthur, and it doesn\'t hurt to appeal to authority.  I\'ll try to bring Joanna into the conversation.',
		    transition: '“I doubt Joanna will let us help her.  But you can ask.”</p><p>“She\'d allow it on your advice.”</p><p>“I can\'t really,” Morgan faltered.  “This is between you and her.”',
		    link: 'crystalloid'}),
		synonyms(['point out her concerns about setting a good example for Carter and Giles'], {
		    thought: 'It\'d be pretty bad if I made exceptions for Arthur after drilling those two on these issues for so long.',
		    transition: '“We\'ve got to set a good example for them,” she said, nodding towards the students.  “We can\'t be sending mixed messages about noninterference.”',
		    link: 'crystalloid'}),
		synonyms(['point out the ethical guidelines'], {
		    thought: 'There is, in fact, a guideline specifically for this situation.  I don\'t want to oppose Arthur, so perhaps I can transfer the blame to it.',
		    transition: '“I see what you mean.  But what about that guideline?  ‘The decision to treat sick or injured free-living wild animals should not be based on welfare grounds alone.’”',
		    link: 'crystalloid'}),
		synonyms(['point out the lack of data on rehabilitated dinosaurs'], {
		    thought: 'There may be data from Earth, but that doesn\'t mean it translates here.',
		    flags: ['romance', 'flirtation'],
		    transition: '“But we don\'t know anything about what rehabilitating her would do.  The only data point we have on this planet is that dinosaur we hit with the boat.”  She put her hand on his arm.  No one liked to think about that.  “We shouldn\'t risk those unknowns just to salvage a stegosaurid.”',
		    link: 'crystalloid'}),
		synonyms(['point out the stress of prolonged detention'], {
		    thought: 'Forget the conversation for a moment.  He may end up hurting where he means to help, and I don\'t want that to happen.',
		    transition: '“Mmh, she doesn\'t look like she enjoys being held by the Armatron.  Don\'t forget that getting separated from the herd or even the stress of being held too long could kill her too.  I think a release will be more welcome than an IV.”',
		    link: 'crystalloid'}),
		synonyms(['point out that rehabilitation would only lengthen the stegosaurid\'s suffering'], {
		    thought: 'I\'m worried that he\'ll discover later that treatment only extended her suffering.  A little disagreement here to prevent that is probably worth it.',
		    flags: ['pain'],
		    transition: '“Arthur, if she\'s going to die, it\'s best to let that happen.  No sense in prolonging things.”  She felt like she was talking to a child, not the guy she had her eye on.',
		    link: 'crystalloid'}),
		synonyms(['point out that the stegosaurid\'s wounds were not human-inflicted'], {
		    thought: 'His job is to help us not tamper with the ecosystem.  Treating her is the opposite.  I\'m confused.',
		    transition: '“Arthur, aren\'t you supposed to preserve the ecosystem from human interference?  Why do you want to intervene now?”',
		    link: 'crystalloid'}),
		synonyms(['point out the precedent that interfering will set'], {
		    thought: 'We\'ve kept the ecosystem almost untouched so far.  Let\'s not mess that up now.',
		    flags: ['romance'],
		    transition: '“I get your concern.”  She put her hand on his arm.  “But we have to stick to the rules.  If we slip now, I worry that it will be harder not to slip in the future, and eventually we\'ll lose all scientific validity.”  She felt like she was talking to a child, not the guy she had her eye on.',
		    link: 'crystalloid'}),
		synonyms(['point out the need to consider these things carefully'], {
		    thought: 'If he stops to think, he\'ll see the problem, and I won\'t have to argue with him.',
		    flags: ['romance', 'flirtation'],
		    transition: '“Whoa.  Slow down.  Think about what you\'re suggesting.”  She put her hand on his arm.',
		    link: 'crystalloid'}),
		synonyms(['point out that a rescue would cut into the science budget'], {
		    thought: 'Money\'s always a minefield topic.  But maybe we can find common ground in frustration with the program\'s budget.',
		    transition: '“It\'s too bad.  If we had more funds we could pull that off, but I don\'t think there\'s enough with so much science yet to—”',
		    link: 'crystalloid'}),
	    ], 'Have Morgan …');
	}
    }),
    crystalloid: new undum.Situation({
	enter: function(character, system, from) {
	    paragraph(system, character, '[pain]“[end pain][~pain][gotten]“Why not?[end gotten][~gotten][sidled]Arthur spun away to face her.[end sidled][~sidled]Arthur huffed.[end ~sidled]  “You\'re not getting it.[end ~gotten]  Remember Max\'s nociception study?  Variable response and learned avoidance.  Pain.  Real, honest-to-goodness pain.  [end ~pain]Look at her!  [pain]Think she\'ll be any worse off than that?  [end pain]She\'s suffering.”  Arthur let that sink in.  “And I\'m a vet.  [pain]I can fix that.[end pain][~pain]Helping animals is my job.[end ~pain]”  He himself looked to be hurting.  “Listen, I have plenty of crystalloid fluid back at base.  That and one of the large drip chambers.  That\'s all it would take.”');
	    paragraph(system, character, 'Morgan hesitated.');
	    paragraph(system, character, '“I\'m sorry, Arthur.”');
	    paragraph(system, character, 'The stegosaurid squirmed.  He stared at it silently.');
	    paragraph(system, character, '“Giles,” she piped, “You two all done?  Cool.  Everyone back in the rovers so Joanna can let her go.”')
	    paragraph(system, character, 'Morgan shook her head.  Before taking her seat, she gave a thumbs-up to the Armatron.  “Thanks a bunch, Joanna.  You did an awesome job on that capture.  We\'re going to make a few waves with this,” she said, indicating her data pad.');
	    dinkus(system);
	    pause(system, 'chapter2');
	}
    }),
    chapter2: new undum.Situation({
	enter: function(character, system, from) {
	    clear_chapter(system, character, '2');
	    paragraph(system, character, '“Hey, Minna?” asked Arthur, popping his head into her office.  “You wouldn\'t happen to have the migratory route for the herd we visited today, would you?”');
	    paragraph(system, character, '“Not yet,” she said, eyes not leaving the screen, hand not leaving the joystick.');
	    paragraph(system, character, '“Not yet?”');
	    paragraph(system, character, '“Nope.  That was the first encounter since we put trackers on them.  I know \'cause Joanna was just in here kicking herself for not tagging the new juveniles.  The network should have uploaded everything to Morgan\'s pad when you were out there, but I\'m still waiting for her to send the files.  She\'s been making a bunch of calls to Earth, I guess.”');
	    pause(system, 'radioed');
	}
    }),
    radioed: new undum.Situation({
	enter: function(character, system, from) {
	    if (first_time(character, 'radioed')) {
		clear_flags(character, ['sidled', 'gotten', 'pain']);
		chapter(system, character, '2', 'Theft', 'Bláveröld Base – Noontime', 'Arthur');
		paragraph(system, character, '“Arthur, you have a minute?” asked Morgan.');
		paragraph(system, character, '“Oh, hi.” he said, slipping a flat cylinder and the screen he was working on off to one side.  “What\'s up?”');
		paragraph(system, character, '“You were driving behind me on the way back, weren\'t you?  You didn\'t see anything fall out of my rover, did you?”');
		paragraph(system, character, '“I would\'ve radioed if I did.”');
		paragraph(system, character, '“Yeah, that\'s what I thought.  Look,” she said, lowering her voice, “my data pad\'s missing.  I swear it was in my pack, which I know went straight from the rover to my office.  I don\'t want to jump to conclusions, but everyone knew we had a big find…”');
		goals(system, character, ['convince Morgan that her data pad wasn\'t stolen']);
		verbs(system, character, ['help', 'defend'], ['help …', 'defend …'], true);
	    } else {
		goals(system, character, ['convince Morgan that her data pad wasn\'t stolen']);
		verbs(system, character, ['help', 'defend'], ['help …', 'defend …'], false);
	    }
	    parse(this, system, character, [
		synonyms(['x Morgan (look at Morgan)', 'look at Morgan', 'wait', 'z (wait)'], {
		    thought: 'Does she know?  I won\'t finish her sentence; I\'ll just let her keep talking.',
		    transition: 'Arthur frowned, trying to take in her suggestion.',
		    link: 'locked'}),
		synonyms(['x the data pad (look at the data pad)', 'look at the data pad'], {
		    thought: 'Good, she hasn\'t noticed that it\'s not mine yet.  It\'s not obvious is it?',
		    transition: 'Arthur\'s eyes wandered to the data pad.  It was indistinguishable from his own.  Morgan didn\'t catch the cue; she only understood him to be weighing her accusation.',
		    link: 'locked'}),
		synonyms(['x the cylinder (look at the cylinder)', 'look at the cylinder'], {
		    thought: 'I can\'t imagine her distinguishing her data pad from my own.  By that magnet—is it going to give me away?',
		    transition: 'Arthur\'s eyes wandered to the magnet sitting by the data pad.  The labeled side was face-down.  He doubted than anyone but Joanna or himself could recognize it like that, which removed a lot of his anxiety.  Morgan didn\'t catch any of this; she only understood him to be weighing her accusation.',
		    link: 'locked'}),
		synonyms(['x Morgan\'s office (look at Morgan\'s office)', 'look at Morgan\'s office', 'help Morgan look for her data pad'], {
		    thought: 'It\'s, erm, unlikely that I can help.  But better make a good show of it.',
		    flags: 'moved',
		    transition: '“Can I help you look for it?” he interjected.</p><p>“Well, okay, but I\'ve already turned my office upside-down.”</p><p>They made their way there.  Arthur\'s search yielded innumerable stray bits of packing foam, an old vial of dermestidae, and three forgotten jars of India ink, but no data pad.',
		    link: 'locked'}),
		synonyms(['point out the likelihood of theft'], {
		    thought: 'At this point, theft is the only likely deduction.  Drat.',
		    transition: '“You think someone stole it?”',
		    link: 'locked'}),
		synonyms(['talk to Morgan'], {
		    thought: 'She doesn\'t know who did it.  There\'s no harm accepting the obvious.',
		    transition: 'Arthur, wide-eyed, nodded.  “You think someone stole it?”',
		    link: 'locked'}),
		synonyms(['talk to Joanna'], {
		    thought: 'I might have a better chance of convincing Morgan if I bring Joanna, who will be skeptical, into the conversation.',
		    flags: ['upchain'],
		    transition: '“I don\'t know, Morgan.  But Joanna\'s the person to tell, not me.”',
		    link: 'locked'}),
		synonyms(['defend the team', 'point out the unlikelihood of theft'], {
		    thought: 'I don\'t want anyone getting in trouble over this.  It being lost is still a very viable hypothesis.',
		    flags: 'moved',
		    transition: '“Morgan, that kind of thing doesn\'t happen here.”</p><p>“Really?” she said, beckoning.  “Then where is it?”</p><p>He followed her to her office.  With his help, the search yielded innumerable stray bits of packing foam, an old vial of dermestidae, and three forgotten jars of India ink.  But no data pad.',
		    link: 'locked'}),
	    ], 'Have Arthur …');
	}
    }),
    locked: new undum.Situation({
	enter: function(character, system, from) {
	    paragraph(system, character, '“[upchain]But[end upchain][~upchain][moved]See?[end moved][~moved]Mm-hmm.[end ~moved]  And[end ~upchain] my office was locked the whole time I was in the conference room.  I can\'t imagine anybody getting past Joanna\'s security except, well—I hate to say it—Joanna.”');
	    paragraph(system, character, '“Who would never do such a thing.”');
	    paragraph(system, character, 'She paused.  “Okay, but consider this.  I had Carter and Giles digging through the literature for flesh-grazer bites like the ones we saw this morning.  They both had a whole bunch to show me, too many for them not to have been working during my calls.  Minna\'s been getting drones out of the way of a forest fire all day; I checked up on the flight logs, and they were only interrupted when she left to get some trackers ready.  Max is still out with the sauropods.  Lydia and Walter took off looking for gymnosperms just after sunrise.  That doesn\'t leave many options.”');
	    goals(system, character, ['convince Morgan that her data pad wasn\'t stolen', 'keep Morgan from falsely accusing Joanna']);
	    verbs(system, character, ['help', 'defend'], ['help …', 'defend …'], false);
	    parse(this, system, character, [
		synonyms(['x Morgan (look at Morgan)', 'look at Morgan'], {
		    thought: 'Is this the Morgan I know?  She and Joanna always got along so well.',
		    flags: ['convinced'],
		    transition: '“But suppose that you\'re wrong.  You and Joanna work so well together, and I get the impression that you\'re good friends.  Give yourself some time to think before you risk losing that.”',
		    link: 'fair'}),
		synonyms(['talk to Morgan'], {
		    thought: 'This is getting out of hand.  I don\'t want to drag Joanna into some fiasco.',
		    flags: ['convinced'],
		    transition: '“So you\'ve identified means and opportunity.  You\'re still missing motive.  Heck, you still don\'t know for sure whether there\'s been a theft at all.  You need to take things in their proper order.”',
		    link: 'fair'}),
		synonyms(['wait', 'z (wait)'], {
		    thought: 'Gah, she\'s already made up her mind.  Okay, I\'ll let this run its course and then attempt damage control.',
		    flags: ['wait'],
		    transition: 'His glance strayed out the window.  Rainclouds.',
		    link: 'fair'}),
		synonyms(['point out the implausibility of her accusation'], {
		    thought: 'Morgan should know how tenuous Joanna\'s appointment here is.  That should be enough to allay any suspicions.',
		    flags: ['convinced'],
		    transition: '“Okay, imagine Joanna doing that.  What\'s going through her mind?  She\'s going to risk her appointment to Bláveröld to sabotage a friend and scientist after fighting to her get here?”',
		    link: 'fair'}),
		synonyms(['point out other places the data pad might be'], {
		    thought: 'The forest, her rover, the rover hangar…',
		    flags: ['elsewhere'],
		    transition: '“You still don\'t know that anyone took it.  [moved]We[end moved][~moved]You[end ~moved]\'ve looking through your office.  What about your rover, or the rover hangar?  Or maybe it did fall out in the forest, and I just didn\'t see it.”',
		    link: 'fair'}),
		synonyms(['point out the one person she didn\'t list'], {
		    thought: 'A blind?  That\'s pretty daring.',
		    flags: ['wait'],
		    transition: '“You forgot about me.”</p><p>“Well, what have you been working on?”</p><p>“I\'ve been reviewing some migration routes.”</p><p>“See?  It couldn\'t have been you either.  You\'re not that kind of guy.”</p><p>“Joanna\'s not that kind of person either.”</p><p>“Okay, I get your point.”</p><p>She sank into thought.',
		    link: 'fair'}),
		synonyms(['help Morgan'], {
		    thought: 'I\'ve got what I need.  We\'ll keep looking, and I can “find” her data pad.  The whole thing will blow over.',
		    flags: ['help'],
		    transition: '“Hold on.  There are other places where we should hunt for it first.  C\'mon, let\'s check the rover hangar.  I [~moved]just [end ~moved]need to [moved]stop back at my office for a moment, but[end moved][~moved]get this stuff put away, and[end ~moved] then I\'ll meet you there.”</p><p>“I\'ve already been there.”',
		    link: 'fair'}),
		synonyms(['defend Joanna'], {
		    thought: 'Yeah, but Joanna\'s got nothing to do with it.  This needs to stop now.',
		    transition: '“You\'re crazy!” he growled.  “Joanna?  Absolutely not.  I would bet my life on it.”  She was taken back by his tone.',
		    link: 'fair'}),
	    ], 'Have Arthur …');
	}
    }),
    fair: new undum.Situation({
	enter: function(character, system, from) {
	    if (character.sandbox.flags.indexOf('wait') < 0) {
		paragraph(system, character, '“[elsewhere]Maybe.  But I\'m so sure I had it.[end elsewhere][~elsewhere][convinced]I know.  That\'s a fair point.  It\'s just, when you have eliminated the impossible and all that…[end convinced][~convinced]I stand by what I said.[end ~convinced][end ~elsewhere]”');
		// if (character.sandbox.flags.indexOf('help') < 0) {
		//     paragraph(system, character, '“—”');
		// }
	    }
	    paragraph(system, character, '“Look,” she said,[~wait][~help] interrupting his attempt to respond,[end ~help][end ~wait] “I know I\'ve got to go to her anyway.  But I\'m going to push her to report it higher up also.  And I\'d like someone else present, just in case there are questions later on.  Can you do that for me?  I trust you more than anyone.”');
	    paragraph(system, character, '“Um.  Sure.”');
	    dinkus(system);
	    pause(system, 'chapter3');
	}
    }),
    chapter3: new undum.Situation({
	enter: function(character, system, from) {
	    clear_chapter(system, character, '3');
	    paragraph(system, character, '“So you told Arthur to see if fell out on the drive back, and you just told me.  Anyone else?”');
	    paragraph(system, character, '“No, nobody else yet.  They might have noticed that I\'ve been asking questions, but that\'s it.”');
	    paragraph(system, character, '“Okay.”  She stared at one of her office\'s empty walls, like she did whenever in deep thought.  “Do me a favor, you two, and hold off mentioning it for a bit.  No point causing a ruckus if it\'s just misplaced, and no point broadcasting our investigation if it really was stolen.”');
	    paragraph(system, character, '“Won\'t it be pretty obvious when enforcement shows up?”');
	    paragraph(system, character, '“I\'m not going there just yet.”  Morgan raised an eyebrow; Joanna cut her off.  “You\'ve become a top scientist, Morgan.  There\'s no way anyone\'s getting you off of Bláveröld.  But there are lots of people with other ideas about how the project should be run, and there\'s plenty they could do back home if we gave them a scandal to work with.  If you want me still here in a month and not some Earth-like bureaucracy, then you\'ll give me a chance to clear this up internally.”');
	    pause(system, 'curled');
	}
    }),
    curled: new undum.Situation({
	enter: function(character, system, from) {
	    if (first_time(character, 'curled')) {
		chapter(system, character, '3', 'Intrusion', 'Bláveröld Base – Early Afternoon', 'Joanna');
		paragraph(system, character, 'Joanna was curled up in her office chair, her data pad cradled in one arm, her drawn face propped with the other.  She could have passed for napping, except that periodic kicks from her right foot kept the chair spinning slowly.');
		goals(system, character, ['think of a way to find Morgan\'s data pad']);
		verbs(system, character, ['think about', 'walk'], ['think about …', 'walk …'], true);
	    } else {
		goals(system, character, ['think of a way to find Morgan\'s data pad']);
		verbs(system, character, ['think about', 'walk'], ['think about …', 'walk …'], false);
	    }
	    parse(this, system, character, [
		flag_blocked_synonyms(character, ['pad'], ['x her own data pad (look at her own data pad)', 'look at her own data pad'], {
		    thought: 'All I need is to identify some aspect of our data pads that we can exploit to locate Morgan\'s.',
		    flags: ['pad'],
		    transition: 'The data pads they used were always on.  Their wireless was always active.  The problem was that Morgan\'s pad wasn\'t set to accept connections from any of the devices Joanna had tried, so, even if around, it wasn\'t revealing its location.',
		    link: '.'}),
		flag_blocked_synonyms(character, ['wait'], ['wait'], {
		    thought: 'Should I admit defeat, and hope for some more information to come to light?',
		    flags: ['wait'],
		    transition: 'She considered giving up.  Only for a moment.',
		    link: '.'}),
		flag_blocked_synonyms(character, ['stegosaurid', 'Max', 'exobotanists'], ['think about the stegosaurid'], {
		    thought: 'The most likely motive for a thief would be to steal Morgan\'s data.  Where does that get me?',
		    flags: ['stegosaurid', 'next'],
		    transition: '[next]She[end next][~next]Next, she[end ~next] tried to put herself in the shoes of a thief.  The most likely motive would be to steal Morgan\'s data.  And there she was stuck; that didn\'t make any sense.  No one could hope to get away with publishing independently, and everyone here stood to gain something if Morgan and her students netted a discovery.',
		    link: '.'}),
		flag_blocked_synonyms(character, ['data', 'Max', 'exobotanists'], ['think about the data'], {
		    thought: 'Maybe there\'s some other data that someone wanted to suppress?',
		    flags: ['data', 'next'],
		    transition: '[next]She[end next][~next]Next, she[end ~next] considered the possibility that Morgan\'s data showed something someone didn\'t want to get out.  But what could it be besides a methodological error, which of course would be bad, but not bad enough to warrant theft?',
		    link: '.'}),
		flag_blocked_synonyms(character, ['students'], ['talk to Carter'], {
		    thought: 'Carter has an osteology focus, so the data would be more valuable to him.  Let\'s go see what he has to say.',
		    flags: ['students'],
		    transition: 'She popped into the students\' office to chat with Carter.  He had an osteology focus, so, she had reasoned, the data would be more valuable to him.  But it wasn\'t much help.  He didn\'t really seem to know why the measurements were such a big deal, only that Morgan was excited.  He hadn\'t even gotten a good look at them.  On top of that, he kept calling her “Dr. Gutiérrez”, not “Joanna” like she preferred.  She returned and plopped down in her chair thoroughly frustrated.',
		    link: '.'}),
		flag_blocked_synonyms(character, ['students'], ['talk to Giles'], {
		    thought: 'Giles is good at keeping tabs on and understanding other\'s work.  If there\'s a scientific motive, he\'s the one most likely to realize it.',
		    flags: ['students'],
		    transition: 'She popped into the students\' office to chat with Giles.  He was good at keeping tabs on and understanding other\'s work, she had reasoned, and would be the one most likely to recognize any scientific motive.  If there was one.  But the conversation wasn\'t much help.  Every time he mentioned “healing mediation”, Carter would get excited and interject with a long tangent.  And the signal she did separate from the noise didn\'t suggest any likely motives.  She returned and plopped down in her chair thoroughly frustrated.',
		    link: '.'}),
		flag_blocked_synonyms(character, ['students'], ['walk to Carter and Giles\'s office'], {
		    thought: 'If it\'s data that someone\'s after, the someone is probably, I guess, one of the students.',
		    flags: ['students'],
		    transition: 'She popped into the students\' office to chat with them.  It wasn\'t much help.  Carter didn\'t really seem to know why the measurements were such a big deal, but would still get excited and interject with a long tangent every time Giles mentioned “healing mediation”.  “Sorry, Dr. Gutiérrez, I just get carried away.”  And then he\'d do it again.  The signal she did separate from the noise (mostly thanks to Giles) didn\'t suggest any likely motives.  She returned and plopped down in her chair thoroughly frustrated.',
		    link: '.'}),
		flag_locked_synonyms(character, ['hint0'], ['Max'], ['talk to Max', 'walk to Max\'s office'], {
		    thought: '[~lost]I\'m beginning to suspect that we don\'t have a theft on our hands.  [end ~lost]Max should be back by now, and the group calendar says his schedule is clear, unlike everyone else\'s.  I could send him out to search the puzzlegrass.',
		    flags: ['Max', 'lost'],
		    transition: 'Deciding it best to cover all fronts, she sent Max out to search the forest, since his schedule was clear.  He wasn\'t very happy about it, but he went.  She returned to spinning her chair and thinking.',
		    link: '.'}),
		flag_locked_synonyms(character, ['hint0'], ['exobotanists'], ['talk to Lydia and Walter', 'walk to Lydia and Walter\'s offices'], {
		    thought: 'The exobotanists would have come in on the same route.  It\'s a long shot, but I could ask whether they saw anything.',
		    flags: ['exobotanists'],
		    transition: 'Then, remembering that the exobotanists came in on the same route as Morgan\'s crew, she went to ask Lydia whether they had seen anything.  The result was negative.  Likewise with Walter.',
		    link: '.'}),
		flag_locked_synonyms(character, ['hint1'], [], ['talk to Minna', 'walk to Minna\'s office', 'think about the forest fire'], {
		    thought: 'Oh drat!  The forest fire.  If Morgan\'s pad is still out there, we might lose it!',
		    transition: 'Suddenly she remembered the forest fire.  She made a brisk trip to Minna\'s office.',
		    link: 'instantly'}),
		// Hints last.
		flag_blocked_synonyms(character, ['hint0', 'desk'], ['x her desk (look at her desk)', 'look at her desk'], {
		    thought: 'Looking at a blank surface has always helped me come up with more ways to approach a problem.',
		    flags: ['hint0', 'desk'],
		    transition: 'She stared at her desk, blank in an almost empty room.  She knew that the base wasn\'t that big.  Unless Morgan\'s pad had been left behind or destroyed, any of their transmitters should have been able to reach it.  But, being secured, it wasn\'t replying.',
		    link: '.'}),
		flag_blocked_synonyms(character, ['hint0', 'wall'], ['x the wall (look at the wall)', 'look at the wall'], {
		    thought: 'Looking at a blank surface has always helped me come up with more ways to approach a problem.',
		    flags: ['hint0', 'wall'],
		    transition: 'She stared at the wall, blank in an almost empty room.  She knew that the base wasn\'t that big.  Unless Morgan\'s pad had been left behind or destroyed, any of their transmitters should have been able to reach it.  But, being secured, it wasn\'t replying.',
		    link: '.'}),
		flag_blocked_synonyms(character, ['hint0', 'pace'], ['walk around her office'], {
		    thought: 'Pacing has always helped me come up with more ways to approach a problem.',
		    flags: ['hint0', 'pace'],
		    transition: 'She stood up and paced the almost empty room.  She knew that the base wasn\'t that big.  Unless Morgan\'s pad had been left behind or destroyed, any of their transmitters should have been able to reach it.  But, being secured, it wasn\'t replying.',
		    link: '.'}),
		flag_locked_synonyms(character, ['hint0'], ['hint1', 'desk'], ['x her desk (look at her desk)', 'look at her desk'], {
		    thought: 'Looking at a blank surface has always helped me come up with more ways to approach a problem.',
		    flags: ['hint1', 'desk'],
		    transition: 'She stared at her desk, which was also blank.  In her head, she was beating herself up about locking everything down; were it not so hard to get a link to Morgan\'s data pad, it wouldn\'t be so hard to find it.  What she really needed was something already with permission to talk to it.',
		    link: '.'}),
		flag_locked_synonyms(character, ['hint0'], ['hint1', 'wall'], ['x the wall (look at the wall)', 'look at the wall'], {
		    thought: 'Looking at a blank surface has always helped me come up with more ways to approach a problem.',
		    flags: ['hint1', 'wall'],
		    transition: 'She stared at the wall, which was also blank.  In her head, she was beating herself up about locking everything down; were it not so hard to get a link to Morgan\'s data pad, it wouldn\'t be so hard to find it.  What she really needed was something already with permission to talk to it.',
		    link: '.'}),
		flag_locked_synonyms(character, ['hint0'], ['hint1', 'pace'], ['walk around her office'], {
		    thought: 'Pacing has always helped me come up with more ways to approach a problem.',
		    flags: ['hint1', 'pace'],
		    transition: 'She stood up and paced.  In her head, she was beating herself up about locking everything down; were it not so hard to get a link to Morgan\'s data pad, it wouldn\'t be so hard to find it.  What she really needed was something already with permission to talk to it.',
		    link: '.'}),
		flag_locked_synonyms(character, ['hint1'], ['hint2', 'desk'], ['x her desk (look at her desk)', 'look at her desk'], {
		    thought: 'Looking at a blank surface has always helped me come up with more ways to approach a problem.',
		    flags: ['hint2', 'desk'],
		    transition: 'She stared at her desk.  It didn\'t help.',
		    link: '.'}),
		flag_locked_synonyms(character, ['hint1'], ['hint2', 'wall'], ['x the wall (look at the wall)', 'look at the wall'], {
		    thought: 'Looking at a blank surface has always helped me come up with more ways to approach a problem.',
		    flags: ['hint2', 'wall'],
		    transition: 'She stared at the wall.  It didn\'t help.',
		    link: '.'}),
		flag_locked_synonyms(character, ['hint1'], ['hint2', 'pace'], ['walk around her office'], {
		    thought: 'Pacing has always helped me come up with more ways to approach a problem.',
		    flags: ['hint2', 'pace'],
		    transition: 'She stood up and began to pace.  It didn\'t help.',
		    link: '.'}),
	    ], 'Have Joanna …');
	}
    }),
    instantly: new undum.Situation({
	enter: function(character, system, from) {
	    if (first_time(character, 'instantly')) {
		paragraph(system, character, 'Minna responded instantly.  She showed Joanna the path of the fire.  They had maybe a day or two.');
		paragraph(system, character, '“Things could change by then.  Fires are never very predictable,” said Minna.  “I\'d be more worried about the drones.  I\'m afraid that getting those tags ready put me a little behind schedule.”  Joanna nodded as Minna went back to flying.');
	    }
	    goals(system, character, ['think of a way to find Morgan\'s data pad']);
	    verbs(system, character, ['think about', 'walk'], ['think about …', 'walk …'], false);
	    parse(this, system, character, [
		flag_blocked_synonyms(character, ['map'], ['x the map (look at the map)', 'look at the map', 'think about the fire'], {
		    thought: 'I can see what Minna means.  There are a lot of blue dots, which represent aerial drones, clustered in front of that red outline.',
		    flags: ['map'],
		    transition: 'She could see what Minna meant about the threat to their remote tech being more pressing.  Just north of the ria coast, huddled in front of the red outline, was a mass of blue dots, each one representing an aerial drone.  A near thing, but Minna would handle it.  It was the thought of her own tight time limit that wasn\'t helping her to reason any faster.',
		    link: '.'}),
		flag_blocked_synonyms(character, ['drones'], ['x the boxes full of drones (look at the boxes full of drones)', 'look at the boxes full of drones'], {
		    thought: 'The drones form a mobile network.  I helped design them.',
		    flags: ['drones', 'also'],
		    transition: 'Her mind rewound to the time when she had designed the drones.  The were built to establish a mobile network, one that would gradually optimize itself for relaying readings to any authorized data pad that came in range.',
		    link: '.'}),
		flag_locked_synonyms(character, ['drones'], ['trackers'], ['x the cases full of trackers (look at the cases full of trackers)', 'look at the cases full of trackers'], {
		    thought: 'The trackers[also] also[end also] form a mobile network.  We reused the technology from the drones.',
		    flags: ['trackers'],
		    transition: 'Like the drones, her mind went on, the trackers were[also] also[end also] built to cooperatively relay their data to authorized pads.',
		    link: '.'}),
		flag_blocked_synonyms(character, ['Minna'], ['x Minna (look at Minna)', 'look at Minna'], {
		    thought: 'Wow, she\'s gotten much better at flying.',
		    flags: ['Minna'],
		    transition: 'Minna continued maneuvering.  A pale blue dot wandered across the map.',
		    link: '.'}),
		flag_blocked_synonyms(character, ['drones'], ['think about the boxes full of drones', 'x Minna\'s data pad (look at Minna\'s data pad)', 'look at Minna\'s data pad'], {
		    thought: 'If only it were Minna\'s data pad that was lost.  Her\'s is setup to talk to the drones.',
		    flags: ['drones'],
		    transition: 'She wished it was Minna\'s data pad that was lost.  Minna\'s was setup to talk to the drones, which could therefore be used to locate it.',
		    link: '.'}),
		synonyms(['x the wall (look at the wall)', 'look at the wall'], {
		    thought: 'Looking at a blank surface has always helped me brainstorm.',
		    transition: 'She turned to stare at the wall.  An idea was forming.',
		    link: 'trackers'}),
		flag_locked_synonyms(character, ['trackers'], [], ['think about the cases full of trackers'], {
		    thought: 'I\'m close to figuring this out, I know it.',
		    transition: 'She turned to stare at the wall.  An idea was forming.',
		    link: 'trackers'}),
	    ], 'Have Joanna …');
	}
    }),
    trackers: new undum.Situation({
	enter: function(character, system, from) {
	    paragraph(system, character, 'Suddenly Joanna sprang to her feet.  Of course.  The trackers she had gotten from Minna!  She thanked Minna, sprinted back to her office, cabled one to her pad, and started typing furiously.');
	    paragraph(system, character, 'Minna always activated and tested the tags at base so that the scientists wouldn\'t have to worry about flakiness out in the field.  Morgan\'s devices were on the authorized bridge list, so the trackers might have been uploading to her pad during their wake cycles.  Since they logged position data, report times, and RSSI, and had just been carted across the base, there was some chance of a reasonably accurate trilateration.');
	    paragraph(system, character, 'It wasn\'t long before Joanna was knocking on Morgan\'s door.  “Morgan, come with me.  I think I\'ve found it, but I want you there when we check.”');
	    paragraph(system, character, '“You\'ve [~convinced]‘[end ~convinced]found[~convinced]’[end ~convinced] it?” she asked.  “Where?”');
	    dinkus(system);
	    pause(system, 'chapter4');
	}
    }),
    chapter4: new undum.Situation({
	enter: function(character, system, from) {
	    clear_chapter(system, character, '4');
	    // paragraph(system, character, '“Come in?”  Joanna did and eyed Arthur suspiciously.  He had his hat on and one arm through a coat sleeve.  She started pacing the room with her data pad, a large-animal tracker hanging off of it.  <a class="critical" href="dissentM">Morgan</a> followed tentatively.  “Um, Jo—”');
	    paragraph(system, character, '“Come in?” called Arthur.  Joanna did and eyed Arthur suspiciously.  He had his hat on and one arm through a raincoat sleeve.  She started pacing the room with her data pad, a large-animal tracker hanging off of it.  Morgan followed tentatively.  “Um, Jo—” he began.');
	    paragraph(system, character, '“Turn out your pockets, please.”');
	    // paragraph(system, character, '<a class="critical" href="dissentA">Arthur</a> cursed.');
	    paragraph(system, character, 'Arthur cursed.');
	    // system.write('<p id="note" class="transient">(Choose a protagonist.)</p>');
	    pause(system, 'dissentA');
	}
    }),
    dissentA: new undum.Situation({
	enter: function(character, system, from) {
	    if (first_time(character, 'dissentA')) {
		chapter(system, character, '4', 'Dissent', 'Bláveröld Base – Late Afternoon', 'Arthur');
		paragraph(system, character, 'Morgan stared blankly at Arthur.  Arthur stared blankly back.');
		paragraph(system, character, '“I was going to get it back to you!  It would have turned up!  I just needed some data!”');
		paragraph(system, character, '“And you couldn\'t have just asked?!”');
		paragraph(system, character, 'Joanna pulled up chairs for all of them.');
		goals(system, character, ['save face', 'save the stegosaurid']);
		verbs(system, character, ['leave'], ['leave …'], true);
	    } else {
		goals(system, character, ['save face', 'save the stegosaurid']);
		verbs(system, character, ['leave'], ['leave …'], false);
	    }
	    parse(this, system, character, [
		synonyms(['x Morgan (look at Morgan)', 'look at Morgan', 'talk to Morgan'], {
		    thought: 'She must feel like I betrayed her.',
		    transition: '“Morgan, it was nothing against you.  I didn\'t want to take it.”</p><p>Her face turned confused.</p><p>That stegosaurid we saw today, the one that was dying?  I was going to go back and save her.  But I didn\'t know where she was headed, and you hadn\'t filed the telemetry with Minna, and I couldn\'t really interrupt your calls for that.  I\'m sorry.  I was running out of time.”  He handed her the data pad.',
		    link: 'dying'}),
		synonyms(['x Joanna (look at Joanna)', 'talk to Joanna'], {
		    thought: 'Morgan is the sort of person who gets all worked up, and then everything is fine.  Joanna, on the other hand is never outwardly angry; you can only tell she\'s upset when she\'s acting serious.  Right now, she\'s very serious.',
		    transition: 'He addressed Joanna.  She wasn\'t so caught up as Morgan, but he could tell she wasn\'t happy.  “Look, I made a mistake.  I needed the migratory route of the herd we saw today, but Morgan hadn\'t filed the telemetry with Minna, and I couldn\'t really interrupt her calls for that.  But then she told me the pad was taken, and I didn\'t want to face her; I thought I could get it back some other way.  I\'m sorry.”  He handed Morgan the data pad.</p><p>“The migratory route?” asked Morgan, considering.  “What in the world for?”</p><p>“Ah, er—”</p><p>“The stegosaurid!”</p><p>He pursed his lips.',
		    link: 'dying'}),
		synonyms(['x Joanna\'s data pad (look at Joanna\'s data pad)', 'look at Joanna\'s data pad'], {
		    thought: 'Of course.  Joanna who can do anything.  She caught me.',
		    transition: 'He handed her the data pad.  “No, I was running out of time.  I\'m still running out of time.  You caught me,” he said, turning to Joanna, “but please let me finish.  I\'m going to go back and save the stegosaurid we saw today, the one that was dying.”',
		    link: 'dying'}),
		synonyms(['x the large-animal tracker (look at the large-animal tracker)', 'look at the large-animal tracker'], {
		    thought: 'I am an idiot.  I knew that trackers were set up to talk to her pad—that\'s the whole reason I needed it.',
		    transition: 'He handed her the data pad.  “No, I was running out of time.  I\'m still running out of time.  You out-thought me; you caught me,” he said, turning to Joanna, “but please let me finish.  I\'m going to go back and save the stegosaurid we saw today, the one that was dying.”',
		    link: 'dying'}),
		flag_blocked_synonyms(character, ['cower'], ['wait', 'z (wait)'], {
		    thought: 'Yikes.  Okay, I need a moment to collect my thoughts.',
		    flags: ['cower'],
		    transition: 'He didn\'t speak at first.  They waited.',
		    link: '.'}),
		synonyms(['point out the reason for his actions'], {
		    thought: 'I never meant to steal anything.  I\'ve got to make them see that my intentions were good.',
		    transition: '“That stegosaurid we saw today, the one that was dying?  I was going to go back and save her.  But I didn\'t know where she was headed, and you hadn\'t filed the telemetry with Minna, and I couldn\'t really interrupt your calls for that.  I\'m sorry.  I was running out of time.”  He handed her the data pad.',
		    link: 'dying'}),
		synonyms(['point out his good character'], {
		    thought: 'Maybe they\'ll paint me as the bad guy.  Some things are worth that.  But it wouldn\'t be so bad if they could just see things from my perspective.',
		    transition: '“Morgan, Joanna, you know me pretty well.  I\'m not a thief.  There was just something more important.  Remember that stegosaurid we saw today, the one that was dying?  I had to save her.  I still have to save her.  But I couldn\'t find out where she was headed because Minna didn\'t have the telemetry on file, and, Morgan, you know you wouldn\'t have let me interrupt your calls for that.  I\'m sorry.  I\'m sure you think I\'m a horrible person, but there was a good reason for what I did.”  He handed her the data pad.',
		    link: 'dying'}),
		synonyms(['defend himself'], {
		    thought: 'Morgan is overreacting.',
		    transition: '“Like I said, you would have gotten it back.  No one was after your find.  On the contrary, I was thinking of that stegosaurid.  I was going to go back and save her.  But I didn\'t know where she was headed, and you hadn\'t filed the telemetry with Minna, and I couldn\'t interrupt your calls for that.  I was running out of time, so I had to borrow your data pad.”  He handed it back.',
		    link: 'dying'}),
		synonyms(['walk away', 'help the stegosaurid', 'leave his office'], {
		    thought: 'I can\'t let them stop me.',
		    flags: ['persist', 'angry'],
		    transition: '“No, I couldn\'t.  You didn\'t understand.  Think whatever what you want about me,”—he handed her the data pad—“but that stegosaurid we saw today, the one that was dying?  I\'m going to save her.  The only reason I took your pad is to find out where she was headed; you hadn\'t filed the telemetry with Minna.”',
		    link: 'dying'}),
	    ], 'Have Arthur …');
	}
    }),
    dying: new undum.Situation({
	enter: function(character, system, from) {
	    paragraph(system, character, '“It\'s one animal, Arthur!  What, you think we don\'t have acceptable interference guidelines for a reason?  And you lied to me!  You stole from me, and I came to you because I thought I could trust you, and you lied to me!  Really?  All that for a stegosaurid who\'d probably get eaten anyway?”');
	    paragraph(system, character, '“Yeah.”  He nodded slowly.');
	    paragraph(system, character, '“That\'s….  Okay, that\'s kind of sweet.  But a little crazy too.  What the heck [persist]are[end persist][~persist]were[end ~persist] you thinking?”');
	    pause(system, 'dying2');
	}
    }),
    dying2: new undum.Situation({
	enter: function(character, system, from) {
	    if (first_time(character, 'dying2')) {
		paragraph(system, character, '“Look, how many times have you told me how absurd it is that a place like Bláveröld\'s even exists?  How no one would have dreamed of this much similarity to Earth\'s macroscopic life, let alone life from a chapter that\'s mostly closed to us?  I mean, think of what the stegosaurid gave you today.  You\'re going to have a breakthrough publication, and your students are going to catapult to the front of their field.  Is it so strange to want to give something back?”');
		paragraph(system, character, '“But … but I don\'t know that clandestine IVs are giving back, Arthur.  You\'re only thinking about an individual, not the ecosystem.  You want to give a dino an extra chance, but her death isn\'t some wrong to be corrected: it\'s just how natural selection works.”');
		paragraph(system, character, '“You\'re also being extremely short-sighted,” said Joanna.  “It\'s not just Bláveröld that\'s special; there\'s also the fact that they trust us enough to let us be here, some well-intentioned red tape notwithstanding.  If gratitude is owed to the planet, then we should be equally thankful for that trust.  And we should work to deserve it.”');
	    }
	    goals(system, character, ['save face', 'save the stegosaurid']);
	    verbs(system, character, ['leave'], ['leave …'], false);
	    parse(this, system, character, [
		synonyms(['x Morgan (look at Morgan)', 'look at Morgan', 'talk to Morgan'], {
		    thought: 'She seems too ready to attack my stance, and not ready enough to defend her own.  How do I get her to think things through?',
		    transition: '“Morgan, It\'s only one animal.  Seriously, on the planetary scale, how much is that going to change things?”  It hurt him a little to ask that.  “I really don\'t understand why you draw the line\'s where you do.  Five minutes in the Armatron, but no tranqs.  Osteoblast counts, but not this IV.  Tell me how that makes any sense.”</p><p>Joanna caught him up.  “You know that a lot of study went into these decisions—that\'s the reason Max is here.  I\'m happy to listen to your criticisms and report them up the chain, but these were the choices we made as a people, and I expected you to honor them.  Especially when your job description is to ‘monitor, prevent, and counteract adverse human interference’.',
		    link: 'scale'}),
		synonyms(['x Joanna (look at Joanna)', 'look at Joanna', 'talk to Joanna'], {
		    thought: 'She seems too quick to side with Morgan.  How do I get her to see the arbitrariness and absurdity of that position?',
		    transition: '“That seems a little over-the-top, Joanna.  It\'s only one animal.  Seriously, on the planetary scale, how much is that going to change things?”  It hurt him a little to ask that.  “I really don\'t understand why the line\'s drawn where it is.  Five minutes in the Armatron, but no tranqs.  Osteoblast counts, but not this IV.  Tell me how that makes any sense.”</p><p>“You know that a lot of study went into these decisions—that\'s the reason Max is here.  I\'m happy to listen to your criticisms and report them up the chain, but these were the choices we made as a people, and I expected you to honor them.  Especially when your job description is to ‘monitor, prevent, and counteract adverse human interference’.',
		    link: 'scale'}),
		synonyms(['x Joanna\'s data pad (look at Joanna\'s data pad)', 'look at Joanna\'s data pad', 'point out Joanna\'s hypocrisy'], {
		    thought: 'Considering, for instance, how we\'re using telemetry, it\'s pretty clear who\'s acting justly.',
		    flags: ['angry'],
		    transition: '“Hold on.  Think about it.  Here I am using our animal trackers to try and save a life.  You, on the other hand, are using them to try to stop me, to hunt me down and get me off the planet.  How, exactly, does that put me in the wrong?”</p><p>“Arthur, you\'re forgetting everything your training should have taught you about wildlife stewardship.  And we don\'t want you gone,” Joanna continued, “you\'re just making a firing seem like the only viable option right now.  Especially when your job description is to ‘monitor, prevent, and counteract adverse human interference’.',
		    link: 'scale'}),
		flag_blocked_synonyms(character, ['scowl'], ['wait', 'z (wait)'], {
		    thought: 'Really?  They\'re ganging up on me?',
		    flags: ['scowl', 'angry'],
		    transition: 'He clammed up, but was clearly unhappy.',
		    link: '.'}),
		synonyms(['help the stegosaurid', 'think about the stegosaurid', 'defend his cause'], {
		    thought: 'There\'s not much hope then.  But let me make one last effort.',
		    transition: '“It\'s only one animal.  Seriously, on the planetary scale, how much is that going to change things?”  It hurt him a little to ask that.  “I really don\'t understand why the line\'s drawn where it is.  Five minutes in the Armatron, but no tranqs.  Osteoblast counts, but not this IV.  Tell me how that makes any sense.”</p><p>“You know that a lot of study went into these decisions—that\'s the reason Max is here.  I\'m happy to listen to your criticisms and report them up the chain, but these were the choices we made as a people, and I expected you to honor them.  Especially when your job description is to ‘monitor, prevent, and counteract adverse human interference’.',
		    link: 'scale'}),
		synonyms(['walk away'], {
		    thought: 'See if they can stop me.',
		    transition: 'He started to walk away.  Joanna cleared her throat.',
		    link: 'scale'}),
	    ], 'Have Arthur …');
	}
    }),
    scale: new undum.Situation({
	enter: function(character, system, from) {
	    paragraph(system, character, '“We\'ll talk later this evening, but for now I\'m suspending your employment and”—she typed for a few seconds—“disabling your lab access card.  You will remain in housing until a personnel carrier arrives.”');
	    paragraph(system, character, 'Arthur fidgeted.  The other two got up to leave.');
	    pause(system, 'magnet');
	}
    }),
    magnet: new undum.Situation({
	enter: function(character, system, from) {
	    paragraph(system, character, '“Wait.  One more thing.  Show me how you got into her office without tripping an alarm.”');
	    paragraph(system, character, '[angry]Arthur glared.  Then he[end angry][~angry]He[end ~angry] fished something that looked like a hockey puck out of his desk and handed it to her.');
	    paragraph(system, character, '“What\'s that?” asked Morgan.');
	    paragraph(system, character, '“One of the superconducting magnets from the mobile MRI.  Remember back when they kept having cryostat failures and you taught me how to fix them?” he asked Joanna.  “I was messing around with one after loading it up with a test current and discovered that I could overpower my office lock.  Then today I realized that you had never asked me about that, so the door probably hadn\'t logged anything.”');
	    paragraph(system, character, '“Peachy.  Morgan, remind me to ask for some bond sensors in our next shipment.”');
	    dinkus(system);
	    pause(system, 'chapter5a');
	}
    }),
    chapter5a: new undum.Situation({
	enter: function(character, system, from) {
	    clear_chapter(system, character, '5');
	    paragraph(system, character, 'Morgan wasn\'t getting much work done that evening.');
	    paragraph(system, character, 'He had been so adamant about that IV.  He cared about that stegosaurid, enough to lose his job.');
	    paragraph(system, character, 'When Morgan considered herself, she couldn\'t find anything like that.  [romance]She wanted to be with Arthur, but what[end romance][~romance]What[end ~romance] had she done for him[~romance], for instance[end ~romance]?  [flirtation]A little flirting before she helped[end flirtation][~flirtation]Helped[end ~flirtation] kick him off the planet, that\'s what.');
	    paragraph(system, character, 'Through her skylight, she watched the clouds roll back to sea.  She shook her head.');
	    paragraph(system, character, 'She decided to take a walk around the base.');
	    pause(system, 'discovery');
	}
    }),
    discovery: new undum.Situation({
	enter: function(character, system, from) {
	    chapter(system, character, '5', 'Rebellion', 'Rover Hangar – Evening', 'Morgan');
	    paragraph(system, character, 'A noise from the rover hangar.  She went to investigate.');
	    paragraph(system, character, '“Arthur?  You\'re supposed to be in housing.”');
	    paragraph(system, character, '“Morgan!  Morgan, listen to me.  I know you don\'t agree, but this is the one thing that really matters to me.  Joanna says I\'m leaving, so I\'m leaving.  But I\'ve got to do this first.”  The Armatron\'s engine rumbled.');
	    parse(this, system, character, [
		synonyms(['help Arthur', 'leave with Arthur'], {
		    thought: 'Yes, Arthur\'s right about this.',
		    link: 'join'}),
		synonyms(['talk to Joanna'], {
		    thought: 'No, Arthur\'s wrong about this.',
		    link: 'tell'}),
	    ], 'Have Morgan …');
	}
    }),
    join: new undum.Situation({
	enter: function(character, system, from) {
	    paragraph(system, character, '“Wait!”');
	    paragraph(system, character, 'Arthur hesitated.');
	    paragraph(system, character, 'She thought long and hard.  It was terrifying, but it finally came out.  “I\'ll come too.”');
	    paragraph(system, character, 'Arthur hesitated.');
	    paragraph(system, character, '“You\'re crazy, you know that?” she laughed, climbing into the cab.  He was baffled.  “Think your dino\'s going to stay still without someone at the controls?”');
	    parse(this, system, character, [
		flag_locked_synonyms(character, ['flirtation'], [], ['take Arthur\'s hand'], {
		    thought: 'I guess I love him.',
		    transition: 'She took his hand in hers.  He reacted.  She dropped his hand.</p><p>“Are you okay, Morgan?”</p><p>“Yeah, sorry.  I\'ll be fine.  Let\'s go.”',
		    link: 'afterjoin'}),
		synonyms(['take the Armatron to the stegosaurid', 'leave', 'help Arthur'], {
		    thought: 'Let\'s go.  [flirtation]Just me and Arthur.[end flirtation][~flirtation]There\'s not much time.[end ~flirtation]',
		    transition: 'He was nonplussed for a few seconds.  “Well?” she asked.  They drove off.</p><p>[flirtation]She tried to joke with him on the way, to start a conversation, to alleviate some of the tension.  He remained stiff and terse, all business.[end flirtation][~flirtation]The drive was silent.  She tried to piece together why she was doing this.  She couldn\'t.  Morgan began to regret her decision, a choice that would throw everything she had worked for away.  But she was trapped: it was too late; she was already guilty.[end ~flirtation]',
		    link: 'afterjoin'}),
		synonyms(['z (wait)', 'wait'], {
		    thought: 'I\'ll wait for him to overcome his surprise.',
		    transition: 'He was nonplussed for a few seconds.  “Well?” she asked.  They drove off.</p><p>[flirtation]She tried to joke with him on the way, to start a conversation, to alleviate some of the tension.  He remained stiff and terse, all business.[end flirtation][~flirtation]The drive was silent.  She tried to piece together why she was doing this.  She couldn\'t.  Morgan began to regret her decision, a choice that would throw everything she had worked for away.  But she was trapped: it was too late; she was already guilty.[end ~flirtation]',
		    link: 'afterjoin'}),
		synonyms(['talk to Arthur'], {
		    thought: '[flirtation]I should tell him how I feel.[end flirtation][~flirtation]I should explain why I\'m doing this.[end ~flirtation]',
		    transition: '[flirtation]Eventually he overcame his surprise, and they were on their way.  She summoned her courage.</p><p>“Arthur, I think there\'s something you should know.”</p><p>“You\'re acting really strange.  Are you sure you\'re okay?”</p><p>“I\'m just a little nervous because—”</p><p>“—because what we\'re doing will get you fired?  Don\'t worry.  You don\'t tell anyone, I won\'t tell anyone.”</p><p>She was silent.  In the corner of her mind a thought was forming, a thought that maybe this wasn\'t the guy she wanted to be with.[end flirtation][~flirtation]“Arthur, I think you need to understand something.  I\'ve come to respect you for fighting so hard for this animal, and that\'s why I didn\'t radio Joanna.  I think you should get this chance.  But we have to tell her when we get back.”</p><p>“You do know that she\'ll probably ship you off too?  Look, if you don\'t tell anyone, I won\'t either.”</p><p>“What?  But—”</p><p>“I\'m serious.  Think about it.”</p><p>She did.  She had to admit that he was probably right.  Now it was a decision between her morals and her career.  And she realized, dejectedly, which she would choose.[end ~flirtation]',
		    link: 'afterjoin'}),
	    ], 'Have Morgan …');	    
    	}
    }),
    afterjoin: new undum.Situation({
	enter: function(character, system, from) {
	    rechapter(system, character, '5', 'Rebellion', 'Puzzlegrass Forest – Evening', 'Morgan');
	    paragraph(system, character, 'It was a long time before they found the stegosaurid, which had fallen behind the herd.  Its breathing was far too shallow for the humid air.  Morgan got a workable grip, though not one as good as Joanna\'s, and Arthur began the IV.  She had the vitals from Arthur\'s instruments up on the Armatron\'s HUD.  The blood pressure was climbing, and the pulse was dropping; she could see the dinosaur\'s heart returning to normal.');
	    paragraph(system, character, 'She could feel her own heart breaking.  <span class="tombstone">∎</span>');
	    end(system);
	}
    }),
    tell: new undum.Situation({
	enter: function(character, system, from) {
	    paragraph(system, character, '“Wait!”');
	    paragraph(system, character, 'Arthur hesitated.');
	    paragraph(system, character, 'She thought long and hard.  Then she grabbed her radio.');
	    pause(system, 'tell2');
	}
    }),
    tell2: new undum.Situation({
	enter: function(character, system, from) {
	    paragraph(system, character, 'He was away.  But Morgan talked fast, and Joanna typed faster.  The engine shut down less than a hundred meters from the hangar.');
	    paragraph(system, character, 'He didn\'t run.  There was no point in that.  Instead, he came walking back, head hung in defeat.');
	    paragraph(system, character, 'When he got inside, Joanna, a little out of breath, was waiting for him.');
	    dinkus(system);
	    pause(system, 'aftertell');
    	}
    }),
    aftertell: new undum.Situation({
	enter: function(character, system, from) {
	    paragraph(system, character, 'The next day, Morgan\'s team made a return trip to see how the specimen\'s bone healing was progressing.  Arthur had been right; they found the stegosaurid dead and partly scavenged.  [flirtation]Morgan finally felt her heart break.[end flirtation][~flirtation]Morgan took her measurements anyway.[end ~flirtation]  <span class="tombstone">∎</span>');
	    end(system);
	}
    }),
    // dissentM: new undum.Situation({
    // 	enter: function(character, system, from) {
    // 	    chapter(system, character, '4', 'Dissent', 'Bláveröld Base – Late Afternoon', 'Morgan');
    // 	}
    // }),
};
